/* FTPAPI.H
   Copyright (c) GP van Niekerk Ondernemings BK 1999
   Resident FTP API definitions
*/

#define FTP_INT		0x62

#define OpenFTPSession		0	// par1=server, par2=user, par3=password
								// session id returned in par5,par6
#define CloseFTPSession		1   // par5,par6 = session id
#define SendFTPCommmand		2	// par1=command; par5,par6 = session id
#define GetFTPFile			3	// par1=remote name, par2=local name
								// par5,par6 = session id
#define GetFTPDirectory		4	// par1=file spec, par4=1 for long listing
								// par5,par6 = session id
#define SendFTPFile			5	// par1=local name, par2=remote name,par4=1 for append
								// par5,par6 = session id
#define CheckFTPStatus		6	// par1=buffer for returned string
								// session id returned in par5,par6
#define CallResident		7	// command in AL:

#define XSF_STOP_LISTEN		1
#define XSF_STATUS			2
#define	XSF_UNLOAD			4

#define SetFTPType			8	// par4=1 for Binary (Image), par4=0 for ASCII
								// par5,par6 = session id

// FTP parameter block. A pointer to this block is passed in BX,CX

typedef struct ftppar {
	char far *par1;
	char far *par2;
	char far *par3;
	int par4;
	int par5;
	int	par6;
} FTPPar;

// status return codes returned by CheckFTPStatus

#define	FSTAT_TX_ERR			1	// error sending file
#define FSTAT_RX_ERR			2	// error receiving file
#define	FSTAT_TX_OK				3	// file sent OK
#define	FSTAT_RX_OK				4	// file received OK
#define FSTAT_LINE_RECEIVED		5	// FTP command line received

// error codes returned by other calls

#define	FERR_UNKNOWN_CALL		20	// Unknown API call
#define	FERR_SESSION_OPEN		21
#define FERR_SESSION_CLOSED		22
#define	FERR_UNKNOWN_HOST		23
#define FERR_NO_MEMORY			24
#define	FERR_TRANSFERRING		25
#define	FERR_PARAMETER_ERROR	26
#define	FERR_FILE_OPEN			27
#define FERR_DIR_LIST			28
#define FERR_CANT_CREATE		29

